#include <bits/stdc++.h>
using namespace std;

int sign(long long x) {
    if (x > 0) { return 1; }
    if (x < 0) { return -1; }
    return 0;
}

struct Vector {
    int x, y;
    Vector() {}
    Vector(int _x, int _y) {
        x = _x, y = _y;
    }
    Vector operator-(const Vector& other) const {
        return Vector(x - other.x, y - other.y);
    }
    Vector operator+(const Vector& other) const {
        return Vector(x + other.x, y + other.y);
    }
    long double operator*(const Vector& other) const {
        return x * 1ll * other.x + y * 1ll * other.y;
    }
    long double operator^(const Vector& other) const {
        return x * 1ll * other.y - y * 1ll * other.x;
    }
    bool operator<(const Vector& other) const {
        return make_pair(sign(x - other.x), sign(y - other.y)) < make_pair(0, 0);
    }
    Vector ort() const {
        return Vector(-y, x);
    }
    ~Vector() {}
};

bool isOnRay(const Vector& O, const Vector& A, const Vector& P) {
    return sign((A - O) ^ (P - O)) == 0 && sign((A - O) * (P - O)) != -1;
}

bool isOnSeg(const Vector& A, const Vector& B, const Vector& P) {
    return isOnRay(A, B, P) && isOnRay(B, A, P);
}

bool intersect(const Vector& A, const Vector& B, const Vector& C, const Vector& D) {
    int l1x = min(A.x, B.x), r1x = max(A.x, B.x);
    int l1y = min(A.y, B.y), r1y = max(A.y, B.y);
    int l2x = min(C.x, D.x), r2x = max(C.x, D.x);
    int l2y = min(C.y, D.y), r2y = max(C.y, D.y);
    if (max(l1x, l2x) <= min(r1x, r2x) && max(l1y, l2y) <= min(r1y, r2y) && sign((B - A) ^ (D - A)) * sign((B - A) ^ (C - A)) != 1 && sign((C - D) ^ (B - D)) * sign((C - D) ^ (A - D)) != 1) {
        return true;
    }
    return false;
}

struct DSU {
    int n;
    vector<int> par, sz, e;
    DSU() {}
    DSU(int _n) {
        n = _n;
        par.resize(n);
        sz.resize(n);
        for (int i = 0; i < n; ++i) {
            par[i] = i, sz[i] = 1;
        }
    }
    int getParent(int v) {
        if (par[v] != v) {
            par[v] = getParent(par[v]);
        }
        return par[v];
    }
    bool uniteSets(int v, int u) {
        v = getParent(v), u = getParent(u);
        if (v == u) {
            return false;
        }
        if (sz[v] < sz[u]) { swap(v, u); }
        sz[v] += sz[u];
        par[u] = v;
        return true;
    }
    ~DSU() {}
};

void solve() {
    int n;
    cin >> n;
    vector<Vector> A(n), B(n);
    vector<int> P(n);
    vector<int> last(n, -1);
    int szall = 0, sume = 0, comps = 0;
    DSU dsu(n * n);
    for (int i = 0; i < n; ++i) {
        cin >> A[i].x >> A[i].y >> B[i].x >> B[i].y;
        for (int j = 0; j < i; ++j) {
            if (intersect(A[j], B[j], A[i], B[i])) {
                ++P[j];
                ++P[i];
                if (last[i] != -1) {
                    ++sume;
                    comps -= dsu.uniteSets(last[i], szall);
                }
            last[i] = szall;
            if (last[j] != -1) {
                    ++sume;
                comps -= dsu.uniteSets(last[j], szall);
            }
            last[j] = szall;
            ++szall;
                // cerr << "i: " << i << ", j: " << j << '\n';
                // cerr << tmp.second.x << ' ' << tmp.second.y << '\n';
            }
        }
    }
    comps += szall;
    // cerr << comps << ' ' << sume << ' ' << szall << '\n';
    int sumf = comps + sume - szall + 1;
    cout << sumf << '\n';
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
    int T = 1;
    cin >> T;
    while (T--) {
        solve();
        cerr << "-----\n";
    }
#else
    int T = 1;
    cin >> T;
    while (T--) {
        solve();
    }
#endif // LOCAL

    return 0;
}
